<?php
/**
 * $Horde: moment/viewMeeting.php,v 1.7 2003/09/01 22:56:37 jan Exp $
 *
 * Copyright 2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file LICENSE for license information.
 */

@define('MOMENT_BASE', dirname(__FILE__));
require_once MOMENT_BASE . '/lib/base.php';

$meetingID = Horde::getFormData('meetingID');

if (!is_null($meetingID)) {
    /* Create a storage instance. */
    $storage = &Moment_Driver::singleton();
    $storage->retrieve();

    $res = $storage->getMeeting($meetingID);
    if (is_a($res, 'PEAR_Error')) {
        $notification->push(_("Invalid Meeting ID."), 'horde.error');
        header('Location: ' . Horde::applicationUrl('list.php'));
        exit;
    }
    $meeting = $res;
} else {
    $notification->push(_("Invalid Meeting ID."), 'horde.error');
    header('Location: ' . Horde::applicationUrl('list.php'));
    exit;
}

if (!array_key_exists('attendees', $meeting)) {
    $meeting['attendees'] = array();
}

require MOMENT_TEMPLATES . '/common-header.inc';
Moment::menu();

$meetingurl = Horde::applicationUrl(Horde::addParameter('meeting.php', 'meetingID', $meetingID));
$delurl = Horde::addParameter($meetingurl, 'actionID', MOMENT_DELETE_MEETING);
$cancelurl = Horde::addParameter($meetingurl, 'actionID', MOMENT_CANCEL_MEETING);

require MOMENT_TEMPLATES . '/viewMeeting/view.inc';
require MOMENT_TEMPLATES . '/common-footer.inc';
