<?php
/**
 * $Horde: mnemo/data.php,v 1.16 2003/06/17 23:27:50 slusarz Exp $
 *
 * Copyright 2001-2003 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

function _cleanup()
{
    global $import_step;
    $import_step = 1;
    return IMPORT_FILE;
}

define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Data.php';

if (!$conf['menu']['import_export']) {
    header('Location: ' . Horde::applicationUrl('index.php', true));
    exit;
}

/* Allow preferred theme to override settings. */
Horde::getThemeConfig(MNEMO_BASE);

/* Importable file types. */
$file_types = array('csv' => _("CSV"));

/* Templates for the different import steps. */
$templates = array(
    IMPORT_FILE => array(MNEMO_TEMPLATES . '/data/import.inc', MNEMO_TEMPLATES . '/data/export.inc'),
    IMPORT_CSVINFO => array($registry->getParam('templates', 'horde') . '/data/csvinfo.inc'),
    IMPORT_MAPPED => array($registry->getParam('templates', 'horde') . '/data/csvmap.inc'),
);

/* Field/clear name mapping. */
$app_fields = array('body' => _("Memo Text"),
                    'category' => _("Category"),
                    'flags' => _("Flags"));

/* Initial values. */
$param = array('file_types'  => $file_types);
$import_format = Horde::getFormData('import_format', '');
$import_step   = Horde::getFormData('import_step', 0) + 1;
$actionID      = Horde::getFormData('actionID');
$error         = false;

/* Loop through the action handlers. */
switch ($actionID) {
case 'export':
    $exportID = Horde::getFormData('exportID');

    /* Create a Mnemo storage instance. */
    require_once MNEMO_BASE . '/lib/Driver.php';
    $storage = &Mnemo_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                    $conf['storage']['params']);
    $storage->retrieve();

    /* Get the full, sorted memo list. */
    $memos = Mnemo::listMemos($storage);

    switch ($exportID) {
    case EXPORT_CSV:
        if (count($memos) == 0) {
            $notification->push(_("There were no memos to export."), 'horde.message');
            $error = true;
        } else {
            $data = array();
            foreach ($memos as $memo) {
                unset($memo['memo_id']);
                unset($memo['desc']);
                $data[] = $memo;
            }
            $csv = &Horde_Data::singleton('csv');
            $csv->exportFile(_("notes.csv"), $data, true);
            exit;
        }
    }
    break;

case IMPORT_FILE:
    $_SESSION['import_data']['target'] = Horde::getFormData('notepad_target');
    break;
}

if (!$error) {
    $data = &Horde_Data::singleton($import_format);
    if (is_a($data, 'PEAR_Error')) {
        $notification->push(_("This file format is not supported."), 'horde.error');
        $next_step = IMPORT_FILE;
    } else {
        $next_step = $data->nextStep($actionID, $param);
        if (is_a($next_step, 'PEAR_Error')) {
            $notification->push($next_step->getMessage(), 'horde.error');
            $next_step = $data->cleanup();
        }
    }
}

/* We have a final result set. */
if (is_array($next_step)) {
    /* Create a Mnemo storage instance. */
    require_once MNEMO_BASE . '/lib/Driver.php';
    $storage = &Mnemo_Driver::factory($conf['storage']['driver'], $_SESSION['import_data']['target'],
                                      $conf['storage']['params']);
    $storage->retrieve();
    foreach ($next_step as $row) {
        foreach ($app_fields as $field => $null) {
            if (!array_key_exists($field, $row)) {
                $row[$field] = '';
            }
        }
        $memo_id = $storage->addMemo($row['body'], $row['category']);
        if (!empty($row['flags'])) {
            $storage->setFlag($memo_id, $row['flags'], true);
        }
    }
    $success = $storage->store();
    if (is_a($success, 'PEAR_Error')) {
        $notification->push(sprintf(_("There was an error importing the data: %s"),
                                    $success->getMessage()), 'horde.error');
    } else {
        $notification->push(sprintf(_("%s file successfully imported"),
                                    $file_types[$_SESSION['import_data']['format']]), 'horde.success');
    }
    $next_step = $data->cleanup();
}

$title = _("Import/Export Notes");
require MNEMO_TEMPLATES . '/common-header.inc';
Mnemo::menu();

foreach ($templates[$next_step] as $template) {
    require $template;
}

require MNEMO_TEMPLATES . '/common-footer.inc';
