<?php
/**
 * The MIME_Viewer_webcpp class renders out various content
 * in HTML format by using Web C Plus Plus.
 *
 * Web C Plus plus: http://webcpp.sourceforge.net/
 *
 * $Horde: horde/lib/MIME/Viewer/webcpp.php,v 1.3 2003/01/19 21:23:06 slusarz Exp $
 *
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.3 $
 * @since   Horde 3.0
 * @package horde.mime.viewer
 */
class MIME_Viewer_webcpp extends MIME_Viewer {

    /**
     * Render out the currently set contents using Web C Plus Plus.
     *
     * @access public
     *
     * @param optional array $params  Any parameters the Viewer may need.
     *
     * @return string  The rendered contents.
     */
    function render($params = array())
    {
        global $mime_drivers;

        /* Check to make sure the program actually exists. */
        if (!file_exists($mime_drivers['horde']['webcpp']['location'])) {
            return '<pre>' . sprintf(_("The program used to view this data type (%s) was not found on the system."), $mime_drivers['horde']['webcpp']['location']) . '</pre>';
        }

        /* Create temporary files for Webcpp. */
        $tmpin  = Horde::getTempFile('WebcppIn');
        $tmpout = Horde::getTempFile('WebcppOut');

        /* Write the contents of our buffer to the temporary input file. */
        $contents = $this->mime_part->getContents();
        $fh = fopen($tmpin, 'wb');
        fwrite($fh, $contents, strlen($contents));
        fclose($fh);

        /* Get the extension for the mime type. */
        include_once HORDE_BASE . '/lib/MIME/Magic.php';
        $ext = MIME_Magic::MIMEToExt($this->mime_part->getType());

        /* Execute Web C Plus Plus. Specifying the in and out files didn't
           work for me but pipes did. */
        exec($mime_drivers['horde']['webcpp']['location'] . " --pipe --pipe -x=$ext < $tmpin > $tmpout");
        $results = file($tmpout);
        
        /* Extract the style sheet. */
        $res = preg_split('/(\<\/style\>)|(\<style type\=\"text\/css\"\>)/', implode('', $results));
        $style = $res[1];

        /* Extract the content. */
        $res = preg_split('/\<\/?pre\>/', implode('', $results));
        $body = $res[1];
         
        return '<style>' . $style . '</style><pre>' . $body. '</pre>';
    }

    /**
     * Return the MIME content type of the rendered content.
     *
     * @access public
     *
     * @return string  The content type of the output. 
     */
    function getType()
    {
        return 'text/html';
    }

}
