<?php
/**
 * The MIME_Viewer_images class allows images to be displayed.
 *
 * $Horde: horde/lib/MIME/Viewer/images.php,v 1.11 2003/06/10 21:54:38 slusarz Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.11 $
 * @since   Horde 2.2
 * @package horde.mime.viewer
 */
class MIME_Viewer_images extends MIME_Viewer {

    /**
     * Render out the currently set contents.
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     */
    function render()
    {
        global $browser;

        if ($browser->isViewable($this->getType())) {
            return $this->mime_part->getContents();
        }
    }

    /**
     * Return the content-type.
     *
     * @access public
     *
     * @return string  The content-type of the output.
     */
    function getType()
    {
        global $browser;

        $type = $this->mime_part->getType();
        if ($browser->isBrowser('mozilla') && ($type == 'image/pjpeg')) {
            /* image/jpeg and image/pjpeg *appear* to be the same entity, but
               mozilla don't seem to want to accept the latter.  For our
               purposes, we will treat them the same. */
            return 'image/jpeg';
        } elseif ($type == 'image/x-png') {
            /* image/x-png is equivalent to image/png. */
            return 'image/png';
        } else {
            return $type;
        }
    }
}
