<?php
/**
 * $Horde: kronolith/day.php,v 1.47 2003/05/22 21:48:27 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/DayView.php';

$month = Horde::getFormData('month');
$day = Horde::getFormData('mday');
$year = Horde::getFormData('year');
$timestamp = Horde::getFormData('timestamp');
$dayOb = &new Kronolith_DayView($month, $day, $year, $timestamp);
$title = $dayOb->getTime($prefs->getValue('date_format'));

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    require_once $registry->getParam('templates', 'horde') . '/javascript/print.js';
} else {    
    $print_link = Horde::addParameter('day.php', 'month=' . $month);
    $print_link = Horde::addParameter($print_link, 'mday=' . $day);
    $print_link = Horde::addParameter($print_link, 'year=' . $year);
    $print_link = Horde::addParameter($print_link, 'timestamp=' . $timestamp);
    $print_link = Horde::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        require_once $registry->getParam('templates', 'horde') . '/javascript/open_print_win.js';
    }

    Kronolith::menu();
}

$dayOb->html(KRONOLITH_TEMPLATES);

require KRONOLITH_TEMPLATES . '/common-footer.inc';
