<?php
/**
 * $Horde: kronolith/calendars.php,v 1.22 2003/05/22 21:48:27 chuck Exp $
 *
 * Copyright 2002-2003 Joel Vandal <jvandal@infoteck.qc.ca>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('SHARE_EDIT',   1);
define('SHARE_SAVE',   2);
define('SHARE_DELETE', 3);
define('SHARE_ACCESS', 4);
define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Share.php';

// Exit if this isn't an authenticated user.
if (!Auth::getAuth()) {
    header('Location: ' . Horde::applicationUrl($prefs->getValue('defaultview') . '.php'));
    exit;
}

$to_edit = null;
$onlynew = 0;
$actionID = Horde::getFormData('actionID');

// Handle clients without javascript.
if (is_null($actionID)) {
    if (isset($_POST['edit'])) {
        $actionID = SHARE_EDIT;
    } elseif (isset($_POST['save'])) {
        $actionID = SHARE_SAVE;
    } elseif (isset($_POST['delete'])) {
        $actionID = SHARE_DELETE;
    } elseif (isset($_POST['accesslist'])) {
        $actionID = SHARE_ACCESS;
    } elseif (isset($_POST['back'])) {
        header('Location: ' . Horde::applicationUrl('prefs.php', true));
        exit;
    }
}

/* Run through the action handlers */
switch ($actionID) {
 case SHARE_EDIT:
    $to_edit = Horde::getFormData('share');
    break;

 case SHARE_SAVE:
    $to_edit = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');
    if (empty($id)) {
        $notification->push(_("The calendar name is empty."), 'horde.error');
        break;
    }

    $cal = '';
    if (!isset($to_edit) || $to_edit == '') {
        /* Create New Share */
        $cal = $shares->newShare(md5(microtime()));
        $cal->setOwner(Auth::getAuth(), false);
        $cal->setShareName($id, false);
        $cal->setType(Horde::getFormData('type', 0), false);
        $cal->setDescription(Horde::getFormData('description', ''), false);
        $result = $shares->addShare($cal);
    } else {
        $cal = &$shares->getShare($to_edit);
        $cal->setShareName($id, false);
        $cal->setType(Horde::getFormData('type', 0), false);
        $cal->setDescription(Horde::getFormData('description', ''));
    }

    unset($to_edit);
    $notification->push(sprintf(_("The calendar \"%s\" has been saved."), $id), 'horde.success');
    break;

 case SHARE_DELETE:
    $to_delete = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');

    if ($to_delete == Auth::getAuth()) {
        $notification->push(sprintf(_("The calendar \"%s\" cannot be deleted."), $id), 'horde.warning');
        break;
    }

    if (isset($to_delete)) {
        $share = $shares->getShare($to_delete);

        // Delete the calendar.
        // $cal = &Kronolith_Driver::factory($conf['calendar']['driver'], $conf['calendar']['params']);
        $res = $calendar->delete($to_delete);
        if (PEAR::isError($res)) {
            $notification->push(sprintf(_("Unable to delete \"%s\": %s"), $share->getShareName(), $res->getMessage()), 'horde.error');
        } else {
            // Remove share and all groups/permissions.
            $shares->removeShare($share);
            $notification->push(sprintf(_("The calendar \"%s\" has been deleted."), $share->getShareName()), 'horde.success');
        }
    } else {
        $notification->push(_("You must select a calendar to be deleted."), 'horde.warning');
    }
    break;

 case SHARE_ACCESS:
    $edit_share = Horde::getFormData('edit_share');
    $id = Horde::getFormData('id');
    $type = Horde::getFormData('type');

    if ($type == 1) {
        header('Location: ' . Horde::applicationUrl('shares/members.php?edit_share=' . $edit_share, true));
    }
    break;
}

$title = _("Calendars");
$js_onLoad = null;

/* Personal Calendars */
$personal_calendars = Kronolith::listCalendars(true);

require KRONOLITH_TEMPLATES . '/common-header.inc';
require_once $registry->getParam('templates', 'horde') . '/javascript/open_share_edit_win.js';
Kronolith::menu();
require KRONOLITH_TEMPLATES . '/calendars/javascript.inc';
require KRONOLITH_TEMPLATES . '/calendars/manage.inc';
require KRONOLITH_TEMPLATES . '/common-footer.inc';
