<?php
/**
 * IMP base inclusion file. This file brings in all of the dependencies that
 * every IMP script will need, and sets up objects that all scripts use.
 *
 * The following variables, defined in the script that calls this one, are
 * used:
 *   $authentication   - The type of authentication to use
 *   $no_compress      - Controls whether the page should be compressed
 *   $session_control  - Sets special session control limitations
 *
 * $Horde: imp/lib/base.php,v 1.57 2003/07/16 02:02:54 slusarz Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of IMP
@define('IMP_BASE', dirname(__FILE__) . '/..');

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &Browser::singleton();
if (isset($session_control)) {
    switch ($session_control) {
    case 'netscape':
        if ($browser->isBrowser('mozilla')) {
            session_cache_limiter('private, must-revalidate');
        }
        break;
    }
}

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('imp');
$conf = &$GLOBALS['conf'];
@define('IMP_TEMPLATES', $registry->getParam('templates'));

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Secret.php';

// IMP base library
require_once IMP_BASE . '/lib/IMP.php';

// Help
require_once HORDE_BASE . '/lib/Help.php';

// Notification system.
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

// Start compression.
if (empty($no_compress)) {
    Horde::compressOutput();
}

// If IMP isn't responsible for Horde auth, and no one is logged into
// Horde, redirect to the login screen. If this is a compose window
// that just timed out, give the user a chance to recover their
// message.
if (!(Auth::isAuthenticated() || (Auth::getProvider() == 'imp'))) {
    if (strstr($_SERVER['PHP_SELF'], 'recompose.php')) {
        // Let this fall through; otherwise we create an infinite
        // inclusion loop.
    } elseif (strstr($_SERVER['PHP_SELF'], 'compose.php')) {
        require IMP_BASE . '/recompose.php';
        exit;
    } else {
        Horde::authenticationFailureRedirect();
    }
}

if (!isset($authentication)) {
    $authentication = 0;
}
if ($authentication !== 'none') {
    if (strstr($_SERVER['PHP_SELF'], 'compose.php')) {
        if (!IMP::checkAuthentication($authentication, true)) {
            require IMP_BASE . '/recompose.php';
            exit;
        }
    } else {
        IMP::checkAuthentication($authentication);
    }
}
