#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
"""
Built-in Constants
==================

A small number of constants live in the built-in namespace.  They are:

"""
"""
The false value of the :class:`bool` type.

"""
False = None
"""
The true value of the :class:`bool` type.

"""
True = None
"""
The sole value of :attr:`types.NoneType`.  ``None`` is frequently used to
represent the absence of a value, as when default arguments are not passed to a
function.

"""
None = None
"""
Special value which can be returned by the "rich comparison" special methods
(:meth:`__eq__`, :meth:`__lt__`, and friends), to indicate that the comparison
is not implemented with respect to the other type.


"""
NotImplemented = None
"""
Special value used in conjunction with extended slicing syntax.


"""
Ellipsis = None
"""
This constant is true if Python was not started with an :option:`-O` option.
See also the :keyword:`assert` statement.


"""
__debug__ = None
"""exit([code=None])

Objects that when printed, print a message like "Use quit() or Ctrl-D
(i.e. EOF) to exit", and when called, raise :exc:`SystemExit` with the
specified exit code.

"""
quitcode=None = None
